<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Add scripts to the back-end Custom Redirects style that page only.
 *
 * @since v.2.2.0
 *
 * @return void
 */
function wppb_print_custom_redirects_script( $hook ){

	if ( $hook == 'profile-builder_page_custom-redirects' ){
		wp_enqueue_style( 'wppb-custom-redirects-ui', WPPB_PAID_PLUGIN_URL . 'add-ons/custom-redirects/assets/wppb_custom_redirects_ui.css', false, PROFILE_BUILDER_VERSION );
	}

	if( $hook == 'profile-builder_page_custom-redirects' ){
		wp_enqueue_script( 'wppb-custom-redirects-ui', WPPB_PAID_PLUGIN_URL . 'add-ons/custom-redirects/assets/wppb_custom_redirects_ui.js', array("jquery", "jquery-ui-accordion"), PROFILE_BUILDER_VERSION, true );
	}

}
add_action( 'admin_enqueue_scripts', 'wppb_print_custom_redirects_script' );

/**
 * Function that creates the Custom Redirects 2 submenu and populates it with repeater fields
 *
 * @since v.2.0
 *
 * @return void
 */
function wppb_custom_redirects_submenu()
{
	// create a new sub_menu page which holds the data for the default + extra fields
	$args = array(
		'menu_title' => __('Custom Redirects', 'profile-builder'),
		'page_title' => __('Custom Redirects', 'profile-builder'),
		'menu_slug' => 'custom-redirects',
		'page_type' => 'submenu_page',
		'capability' => 'manage_options',
		'priority' => 5,
		'parent_slug' => 'profile-builder'
	);
	$redirects_page = new WCK_Page_Creator_PB($args);
}
add_action( 'admin_menu', 'wppb_custom_redirects_submenu', 1 );

function wppb_populate_custom_redirects_fields(){
	// set up the fields array
	// we'll re-use the same redirect types regardless
	$redirect_types = apply_filters('wppb_redirect_types', array(
		'%'.__('After Login','profile-builder').'%'.'after_login',
		'%'.__('After Logout','profile-builder').'%'.'after_logout',
		'%'.__('After Registration','profile-builder').'%'.'after_registration',
		'%'.__('After Edit Profile','profile-builder').'%'.'after_edit_profile',
		'%'.__('After Successful Email Confirmation','profile-builder').'%'.'after_success_email_confirmation',
		'%'.__('After Password Change Request','profile-builder').'%'.'after_password_change_request',
		'%'.__('After Successful Password Reset','profile-builder').'%'.'after_success_password_reset',
		'%'.__('Dashboard (redirect users from accessing the dashboard)','profile-builder').'%'.'dashboard_redirect',
	));

	// Add PMS subscription status redirect types if PMS is active
	if ( function_exists( 'pms_get_subscription_plans' ) ) {
		$pms_redirect_types = array(
			'%'.__('PMS: Subscription Activated','profile-builder').'%'.'pms_subscription_activated',
			'%'.__('PMS: Subscription Cancelled','profile-builder').'%'.'pms_subscription_cancelled',
			'%'.__('PMS: Subscription Abandoned','profile-builder').'%'.'pms_subscription_abandoned',
			'%'.__('PMS: Subscription Renewed','profile-builder').'%'.'pms_subscription_renewed',
			'%'.__('PMS: Subscription Upgraded','profile-builder').'%'.'pms_subscription_upgraded',
			'%'.__('PMS: Subscription Downgraded','profile-builder').'%'.'pms_subscription_downgraded',
			'%'.__('PMS: Subscription Changed','profile-builder').'%'.'pms_subscription_changed',
			'%'.__('PMS: Login with Active Subscription','profile-builder').'%'.'pms_login_active_subscription',
			'%'.__('PMS: Login with Expired Subscription','profile-builder').'%'.'pms_login_expired_subscription',
			'%'.__('PMS: Login with Cancelled Subscription','profile-builder').'%'.'pms_login_cancelled_subscription',
			'%'.__('PMS: Login with Pending Subscription','profile-builder').'%'.'pms_login_pending_subscription',
			'%'.__('PMS: Login with No Subscription','profile-builder').'%'.'pms_no_subscription',
		);
		$redirect_types = array_merge($redirect_types, $pms_redirect_types);
	}

	$redirect_id_or_username = apply_filters('wppb_redirect_id_or_username', array(
		'%'.__('User ID','profile-builder').'%'.'userid',
		'%'.__('Username','profile-builder').'%'.'user',
	));

	// Build URL field description based on available tags
	$url_description = __( 'Can contain the following dynamic tags: {{homeurl}}, {{siteurl}}, {{user_id}}, {{user_nicename}}, {{http_referer}}, and more.', 'profile-builder' );

	// Individual User Redirects
	$fields = apply_filters( 'wppb_cr_user_fields', array(
		array( 'type' => 'radio', 'slug' => 'idoruser', 'title' => __( 'User ID or Username', 'profile-builder' ), 'default' => 'user', 'options' => $redirect_id_or_username, 'required' => 'Yes' ),
		array( 'type' => 'text', 'slug' => 'user', 'title' => __( 'User ID / Username', 'profile-builder' ), 'description' => __( 'Please select and enter the ID or username of your user.', 'profile-builder' ), 'required' => 'Yes' ),
		array( 'type' => 'select', 'slug' => 'type', 'title' => __( 'Redirect Type', 'profile-builder' ), 'default-option' => true, 'description' => 'When do you want to redirect your user? Choose a redirect type.', 'options' => $redirect_types, 'required' => 'Yes' ),
		array( 'type' => 'text', 'slug' => 'url', 'title' => __( 'Redirect URL', 'profile-builder' ), 'description' => $url_description, 'required' => 'Yes' ),
		array( 'type' => 'text', 'slug' => 'id', 'title' => __( 'ID', 'profile-builder' ), 'default' => 0 ),
	));

	// create the new submenu with the above options
	$args = array(
		'metabox_id' 	=> 'wppb_custom_redirects_user',
		'metabox_title' => __( 'Individual User Redirects', 'profile-builder' ) . '<span class="dashicons dashicons-admin-users"></span>',
		'post_type' 	=> 'custom-redirects',
		'meta_name' 	=> 'wppb_cr_user',
		'meta_array' 	=> $fields,
		'context'		=> 'option',
		'sortable'		=> false
	);
	new Wordpress_Creation_Kit_PB( $args );

	// User Role based Redirects
	//user roles
	global $wp_roles;

	$user_roles = array('%'. __( '... Choose', 'profile-builder' ).'%');
	foreach( $wp_roles->roles as $user_role_slug => $user_role ) {
        array_push( $user_roles, '%' . wppb_prepare_wck_labels( $user_role['name'] ) . '%' . $user_role_slug );
	}

	$fields = apply_filters( 'wppb_cr_role_fields', array(
		array( 'type' => 'select', 'slug' => 'user_role', 'title' => __( 'User Role', 'profile-builder' ), 'description' => __( 'Select a user role.', 'profile-builder' ), 'options' => $user_roles, 'required' => 'Yes' ),
		array( 'type' => 'select', 'slug' => 'type', 'title' => __( 'Redirect Type', 'profile-builder' ), 'default-option' => true, 'description' => 'When do you want to redirect your user? Choose a redirect type.', 'options' => $redirect_types, 'required' => 'Yes' ),
		array( 'type' => 'text', 'slug' => 'url', 'title' => __( 'Redirect URL', 'profile-builder' ), 'description' => $url_description, 'required' => 'Yes' ),
		array( 'type' => 'text', 'slug' => 'id', 'title' => __( 'ID', 'profile-builder' ), 'default' => 0 ),
	));

	// create the new submenu with the above options
	$args = array(
		'metabox_id' 	=> 'wppb_custom_redirects_role',
		'metabox_title' => __( 'User Role based Redirects', 'profile-builder' ) . '<span class="dashicons dashicons-groups"></span>',
		'post_type' 	=> 'custom-redirects',
		'meta_name' 	=> 'wppb_cr_role',
		'meta_array' 	=> $fields,
		'context'		=> 'option',
		'sortable'		=> false
	);
	new Wordpress_Creation_Kit_PB( $args );

	// General Redirects. These apply to all users.
	$fields = apply_filters( 'wppb_cr_general_fields', array(
		array( 'type' => 'select', 'slug' => 'type', 'title' => __( 'Redirect Type', 'profile-builder' ), 'default-option' => true, 'description' => 'When do you want to redirect your user? Choose a redirect type.', 'options' => $redirect_types, 'required' => 'Yes' ),
		array( 'type' => 'text', 'slug' => 'url', 'title' => __( 'Redirect URL', 'profile-builder' ), 'description' => $url_description, 'required' => 'Yes' ),
		array( 'type' => 'text', 'slug' => 'id', 'title' => __( 'ID', 'profile-builder' ), 'default' => 0 ),
	));

	// create the new submenu with the above options
	$args = array(
		'metabox_id' 	=> 'wppb_custom_redirects_global',
		'metabox_title' => __( 'Global Redirects', 'profile-builder' ) . '<span class="dashicons dashicons-admin-site"></span> ' ,
		'post_type' 	=> 'custom-redirects',
		'meta_name' 	=> 'wppb_cr_global',
		'meta_array' 	=> $fields,
		'context'		=> 'option',
		'sortable'		=> false
	);
	new Wordpress_Creation_Kit_PB( $args );

	// Redirect Default WordPress Pages.
	$fields = apply_filters( 'wppb_cr_default_wp_pages_fields', array(
		array( 'type' => 'select', 'slug' => 'type', 'title' => __( 'Redirect Type', 'profile-builder' ), 'default-option' => true, 'description' => 'When do you want to redirect your user? Choose a redirect type.', 'required' => 'Yes',
			'options' => array(
				'%'.__('Login ( wp-login.php )','profile-builder').'%'.'login',
				'%'.__('Register ( wp-login.php?action=register )','profile-builder').'%'.'register',
				'%'.__('Lost Password ( wp-login.php?action=lostpassword )','profile-builder').'%'.'lostpassword',
				'%'.__('Author Archive ( http://sitename.com/author/admin )','profile-builder').'%'.'authorarchive',
			) ),
		array( 'type' => 'text', 'slug' => 'url', 'title' => __( 'Redirect URL', 'profile-builder' ), 'description' => $url_description, 'required' => 'Yes' ),
		array( 'type' => 'text', 'slug' => 'id', 'title' => __( 'ID', 'profile-builder' ), 'default' => 0 ),
	));

	// create the new submenu with the above options
	$args = array(
		'metabox_id' 	=> 'wppb_custom_redirects_default_wp_pages',
		'metabox_title' => __( 'Default WordPress Forms and Pages', 'profile-builder' ) . '<span class="dashicons dashicons-wordpress"></span> ',
		'post_type' 	=> 'custom-redirects',
		'meta_name' 	=> 'wppb_cr_default_wp_pages',
		'meta_array' 	=> $fields,
		'context'		=> 'option',
		'sortable'		=> false
	);
	new Wordpress_Creation_Kit_PB( $args );

	// create the info side meta-box
	$args = array(
		'metabox_id' 	=> 'custom-redirects-info',
		'metabox_title' => __( 'How does this work?', 'profile-builder' ),
		'post_type' 	=> 'custom-redirects',
		'meta_name' 	=> 'wppb_custom_redirects_info',
		'meta_array' 	=> '',
		'context'		=> 'option',
		'mb_context'    => 'normal'
	);
	new Wordpress_Creation_Kit_PB( $args );

	// Subscription Plan based Redirects (only if PMS is active)
	if ( function_exists( 'pms_get_subscription_plans' ) ) {
		// Get subscription plans
		$subscription_plans = pms_get_subscription_plans();
		$subscription_plans_options = array(
			'%'. __( '...Choose', 'profile-builder' ).'%',
			'%'. __( 'Any Plan', 'profile-builder' ).'%any'
		);
		
		if ( !empty( $subscription_plans ) ) {
			foreach( $subscription_plans as $subscription_plan ) {
				array_push( $subscription_plans_options, '%' . wppb_prepare_wck_labels( $subscription_plan->name ) . '%' . $subscription_plan->id );
			}
		}

		$fields = apply_filters( 'wppb_cr_subscription_plan_fields', array(
			array( 'type' => 'select', 'slug' => 'subscription_plan', 'title' => __( 'Subscription Plan', 'profile-builder' ), 'description' => __( 'Select a subscription plan.', 'profile-builder' ), 'options' => $subscription_plans_options, 'required' => 'Yes' ),
			array( 'type' => 'select', 'slug' => 'type', 'title' => __( 'Redirect Type', 'profile-builder' ), 'default-option' => true, 'description' => 'When do you want to redirect your user? Choose a redirect type.', 'options' => $redirect_types, 'required' => 'Yes' ),
			array( 'type' => 'text', 'slug' => 'url', 'title' => __( 'Redirect URL', 'profile-builder' ), 'description' => $url_description, 'required' => 'Yes' ),
			array( 'type' => 'text', 'slug' => 'id', 'title' => __( 'ID', 'profile-builder' ), 'default' => 0 ),
		));

		// create the new submenu with the above options
		$args = array(
			'metabox_id' 	=> 'wppb_custom_redirects_subscription_plan',
			'metabox_title' => __( 'Subscription Plan based Redirects', 'profile-builder' ) . '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="m 10.951071,22.655193 c -1.6414171,-0.205916 -3.5758081,-1.068475 -5.0122731,-2.23501 -0.94328,-0.766025 -1.181857,-0.87327 -1.500507,-0.674512 -0.932319,0.581542 -1.215071,0.331936 -1.198567,-1.058062 0.02496,-2.101371 0.241943,-3.142584 0.672136,-3.225194 0.47754,-0.09171 3.561318,1.139933 3.912561,1.562645 0.221719,0.266834 0.160331,0.404101 -0.384871,0.860571 -0.648667,0.543099 -0.648667,0.543099 0.243196,1.224672 4.6571691,3.559068 11.5872441,0.646323 12.5503531,-5.274976 0.27163,-1.670009 1.263047,-2.303337 1.954856,-1.24878 0.255325,0.389205 0.273351,0.709633 0.100298,1.782902 -0.863167,5.353294 -5.822209,8.977595 -11.337182,8.285744 z M 10.624653,19.077156 C 9.3600599,18.722024 9.1681389,18.520771 9.1156939,17.494835 c -0.06004,-1.174372 -0.520684,-1.753317 -1.744921,-2.193015 -1.45253,-0.521691 -1.556673,-0.700925 -1.541162,-2.652348 0.02114,-2.6592954 1.28833,-4.7391761 3.568876,-5.8577071 1.6547741,-0.811611 4.1955171,-0.8400736 5.7487431,-0.064397 1.036772,0.5177592 1.036772,0.5177592 1.14045,1.7807827 0.122329,1.490265 0.320192,1.7756664 1.55849,2.2480054 1.083375,0.413245 1.245457,0.796985 1.084669,2.568038 -0.364707,4.017203 -4.438866,6.839013 -8.306186,5.752962 z m 2.332704,-2.799401 c 0.115111,-0.214828 0.528974,-0.578984 0.919696,-0.809236 1.746836,-1.029414 1.053182,-2.798685 -1.42543,-3.635779 -1.068157,-0.360744 -1.168957,-1.033997 -0.169292,-1.13072 0.494839,-0.04788 0.717321,0.04287 0.888552,0.362431 0.270897,0.505564 1.150246,0.572039 1.331356,0.10065 0.16379,-0.426316 -0.177701,-1.042269 -0.8057,-1.4532524 -0.276652,-0.181051 -0.556849,-0.49863 -0.62266,-0.705731 -0.235263,-0.740349 -1.221071,-0.72629 -1.458475,0.0208 -0.06944,0.218541 -0.398228,0.537815 -0.730629,0.709498 -0.9158861,0.4730514 -1.1538501,1.8528734 -0.454503,2.6353994 0.178573,0.199812 0.874352,0.563472 1.546175,0.808136 1.012558,0.36875 1.210869,0.51916 1.159368,0.879327 -0.09427,0.659247 -1.008195,0.674662 -1.775327,0.02994 -0.645657,-0.542626 -1.16638,-0.535546 -1.3793441,0.01875 -0.145869,0.379673 1.9006671,2.548584 2.4113461,2.555537 0.195565,0.0026 0.449755,-0.170926 0.564867,-0.38575 z M 2.6437629,13.934578 C 2.2586709,13.549952 2.3481649,11.271428 2.8065869,9.7890226 4.9831789,2.7505514 13.773264,0.40495617 19.192807,5.4164334 20.415063,6.546659 20.424413,6.5508128 21.153448,6.2875086 22.222666,5.9013411 22.309284,6.1047613 22.084667,8.4744836 21.858065,10.865172 21.759236,10.97596 20.346792,10.422652 17.299761,9.2290136 16.920196,8.8320916 18.092279,8.0650396 18.652755,7.6982469 18.652755,7.6982469 17.760114,6.9070565 16.096781,5.4327601 14.822308,4.9669839 12.451623,4.9669839 c -1.837407,0 -2.217694,0.066539 -3.3393541,0.5843029 -2.597438,1.1989858 -4.336428,3.7143668 -4.620348,6.6831602 -0.09603,1.004161 -0.256765,1.631153 -0.449347,1.752847 -0.421945,0.266629 -1.104848,0.240892 -1.398811,-0.05271 z"></path></svg>',
			'post_type' 	=> 'custom-redirects',
			'meta_name' 	=> 'wppb_cr_subscription_plan',
			'meta_array' 	=> $fields,
			'context'		=> 'option',
			'sortable'		=> false
		);
		new Wordpress_Creation_Kit_PB( $args );
	}

}
add_action( 'admin_init', 'wppb_populate_custom_redirects_fields', 1 );

/**
 * Function that modifies the table header in Custom Redirects to addField Name, Field Type, Meta Key, Required
 *
 * @since v.2.2.0
 *
 * @param $list, $id
 *
 * @return string
 */
function wppb_custom_redirects_user_header( $list_header ){
	return '<thead><tr><th class="wck-number">#</th><th class="wck-content"><pre class="idorusername">&nbsp;</pre>'. __( '<pre>User ID / Username</pre><pre>Redirect</pre><pre>URL</pre>', 'profile-builder' ) .'</th><th class="wck-edit">'. __( 'Edit', 'profile-builder' ) .'</th><th class="wck-delete">'. __( 'Delete', 'profile-builder' ) .'</th></tr></thead>';
}
add_action( 'wck_metabox_content_header_wppb_cr_user', 'wppb_custom_redirects_user_header' );

/**
 * Function that modifies the table header in Custom Redirects to addField Name, Field Type, Meta Key, Required
 *
 * @since v.2.2.0
 *
 * @param $list, $id
 *
 * @return string
 */
function wppb_custom_redirects_role_header( $list_header ){
	return '<thead><tr><th class="wck-number">#</th><th class="wck-content">'. __( '<pre>User Role</pre><pre>Redirect</pre><pre>URL</pre>', 'profile-builder' ) .'</th><th class="wck-edit">'. __( 'Edit', 'profile-builder' ) .'</th><th class="wck-delete">'. __( 'Delete', 'profile-builder' ) .'</th></tr></thead>';
}
add_action( 'wck_metabox_content_header_wppb_cr_role', 'wppb_custom_redirects_role_header' );

/**
 * Function that modifies the table header in Custom Redirects to addField Name, Field Type, Meta Key, Required
 *
 * @since v.2.2.0
 *
 * @param $list, $id
 *
 * @return string
 */
function wppb_custom_redirects_global_header( $list_header ){
	return '<thead><tr><th class="wck-number">#</th><th class="wck-content">'. __( '<pre>Redirect</pre><pre>URL</pre>', 'profile-builder' ) .'</th><th class="wck-edit">'. __( 'Edit', 'profile-builder' ) .'</th><th class="wck-delete">'. __( 'Delete', 'profile-builder' ) .'</th></tr></thead>';
}
add_action( 'wck_metabox_content_header_wppb_cr_global', 'wppb_custom_redirects_global_header' );

/**
 * Function that modifies the table header in Custom Redirects to addField Name, Field Type, Meta Key, Required
 *
 * @since v.2.2.0
 *
 * @param $list, $id
 *
 * @return string
 */
function wppb_custom_redirects_default_pages_header( $list_header ){
	return '<thead><tr><th class="wck-number">#</th><th class="wck-content">'. __( '<pre>Redirect</pre><pre>URL</pre>', 'profile-builder' ) .'</th><th class="wck-edit">'. __( 'Edit', 'profile-builder' ) .'</th><th class="wck-delete">'. __( 'Delete', 'profile-builder' ) .'</th></tr></thead>';
}
add_action( 'wck_metabox_content_header_wppb_cr_default_wp_pages', 'wppb_custom_redirects_default_pages_header' );

/**
 * Function that modifies the table header in Custom Redirects for Subscription Plan based redirects
 *
 * @param $list, $id
 *
 * @return string
 */
function wppb_custom_redirects_subscription_plan_header( $list_header ){
	return '<thead><tr><th class="wck-number">#</th><th class="wck-content">'. __( '<pre>Subscription Plan</pre><pre>Redirect</pre><pre>URL</pre>', 'profile-builder' ) .'</th><th class="wck-edit">'. __( 'Edit', 'profile-builder' ) .'</th><th class="wck-delete">'. __( 'Delete', 'profile-builder' ) .'</th></tr></thead>';
}
add_action( 'wck_metabox_content_header_wppb_cr_subscription_plan', 'wppb_custom_redirects_subscription_plan_header' );

/**
 * Add contextual help to the side of custom redirects page to understand the priority
 *
 * @since v.2.2.0
 *
 * @param $hook
 *
 * @return string
 */
function wppb_add_content_before_custom_redirects_info(){
	?>
	<p class="cozmoslabs-description"><?php esc_html_e('These redirects happen after a successful action, like registration or after a successful login.', 'profile-builder'); ?></p>

    <div class="cozmoslabs-accordion">
        <h4 class="cozmoslabs-accordion-header"><?php esc_html_e("Which redirect happens depends on the following priority", 'profile-builder'); ?></h4>
        <div class="cozmoslabs-accordion-container">
            <ol>
                <li class="cozmoslabs-description"><?php esc_html_e("Multiple Registration and Edit Profile form settings Redirects", 'profile-builder'); ?></li>
                <li class="cozmoslabs-description"><?php esc_html_e("Individual User Redirects", 'profile-builder'); ?></li>
                <li class="cozmoslabs-description"><?php esc_html_e("User Role based Redirects", 'profile-builder'); ?></li>
                <?php if ( function_exists( 'pms_get_subscription_plans' ) ) : ?>
                <li class="cozmoslabs-description"><?php esc_html_e("Subscription Plan based Redirects", 'profile-builder'); ?></li>
                <?php endif; ?>
                <li class="cozmoslabs-description"><?php esc_html_e("Global Redirects", 'profile-builder'); ?></li>
                <li class="cozmoslabs-description"><?php echo wp_kses_post( __("Individual redirects defined in shortcodes; <strong><em>redirect_priority=\"top\"</em></strong> parameter can be added in any shortcode, then that shortcode redirect will have priority over all other redirects.", 'profile-builder') ); ?></li>
            </ol>
        </div>
    </div>

    <div class="cozmoslabs-accordion">
        <h4 class="cozmoslabs-accordion-header"><?php esc_html_e("Redirect Default WordPress forms and pages", 'profile-builder'); ?></h4>
        <div class="cozmoslabs-accordion-container">
            <p class="cozmoslabs-description"><?php esc_html_e("With these you can redirect various WordPress forms and pages to pages created with profile builder.", 'profile-builder'); ?></p>
            <p class="cozmoslabs-description"><?php esc_html_e( 'You can force access to wp-login.php so you don\'t get locked out of the site by accessing the link:', 'profile-builder' ); ?> <a href="<?php echo esc_url( wp_login_url() ).'?wppb_force_wp_login=true' ?>"><?php echo esc_url( wp_login_url() ).'?wppb_force_wp_login=true' ?></a></p>
        </div>
    </div>

    <?php if ( function_exists( 'pms_get_subscription_plans' ) ) : ?>
    <div class="cozmoslabs-accordion">
        <h4 class="cozmoslabs-accordion-header"><?php esc_html_e("Subscription Plan based Redirects", 'profile-builder'); ?></h4>
        <div class="cozmoslabs-accordion-container">
            <p class="cozmoslabs-description"><?php esc_html_e("These redirects work with the Paid Member Subscriptions plugin. They allow you to redirect users based on the subscription plan they select during registration or checkout.", 'profile-builder'); ?></p>
            <p class="cozmoslabs-description"><strong><?php esc_html_e("Any Plan option:", 'profile-builder'); ?></strong> <?php esc_html_e("Select 'Any Plan' to create a redirect that triggers for any subscription plan, regardless of which specific plan the user has.", 'profile-builder'); ?></p>
        </div>
    </div>

    <div class="cozmoslabs-accordion">
        <h4 class="cozmoslabs-accordion-header"><?php esc_html_e("PMS Subscription Status Redirects", 'profile-builder'); ?></h4>
        <div class="cozmoslabs-accordion-container">
            <p class="cozmoslabs-description"><?php esc_html_e("These redirects are triggered automatically when a user's subscription status changes or when they login. They work with all redirect types (Individual User, User Role, Global).", 'profile-builder'); ?></p>
            
            <p class="cozmoslabs-description"><strong><?php esc_html_e("Status Change Redirects:", 'profile-builder'); ?></strong></p>
            <ul style="margin: 10px 0 0 20px;">
                <li><strong>PMS: Subscription Activated</strong> - <?php esc_html_e("When a pending subscription becomes active", 'profile-builder'); ?></li>
                <li><strong>PMS: Subscription Cancelled</strong> - <?php esc_html_e("When a subscription is cancelled", 'profile-builder'); ?></li>
                <li><strong>PMS: Subscription Abandoned</strong> - <?php esc_html_e("When a subscription is abandoned", 'profile-builder'); ?></li>
                <li><strong>PMS: Subscription Renewed</strong> - <?php esc_html_e("When an expired or cancelled subscription is renewed", 'profile-builder'); ?></li>
                <li><strong>PMS: Subscription Upgraded</strong> - <?php esc_html_e("When a subscription is upgraded", 'profile-builder'); ?></li>
                <li><strong>PMS: Subscription Downgraded</strong> - <?php esc_html_e("When a subscription is downgraded", 'profile-builder'); ?></li>
                <li><strong>PMS: Subscription Changed</strong> - <?php esc_html_e("When a subscription is changed", 'profile-builder'); ?></li>
            </ul>
            
            <p class="cozmoslabs-description" style="margin-top: 15px;"><strong><?php esc_html_e("Login Status Redirects:", 'profile-builder'); ?></strong></p>
            <ul style="margin: 10px 0 0 20px;">
                <li><strong>PMS: Login with Active Subscription</strong> - <?php esc_html_e("When a user with an active subscription logs in", 'profile-builder'); ?></li>
                <li><strong>PMS: Login with Expired Subscription</strong> - <?php esc_html_e("When a user with an expired subscription logs in", 'profile-builder'); ?></li>
                <li><strong>PMS: Login with Cancelled Subscription</strong> - <?php esc_html_e("When a user with a cancelled subscription logs in", 'profile-builder'); ?></li>
                <li><strong>PMS: Login with Pending Subscription</strong> - <?php esc_html_e("When a user with a pending subscription logs in", 'profile-builder'); ?></li>
                <li><strong>PMS: Login with No Subscription</strong> - <?php esc_html_e("When a user with no subscription logs in", 'profile-builder'); ?></li>
            </ul>
        </div>
    </div>
    <?php endif; ?>

    <div class="cozmoslabs-accordion">
        <h4 class="cozmoslabs-accordion-header"><?php esc_html_e("Available tags for dynamic URLs", 'profile-builder'); ?></h4>
        <div class="cozmoslabs-accordion-container">
            <p class="cozmoslabs-description"><?php esc_html_e("You use the following tags in your URLs to redirect users to various pages.", 'profile-builder'); ?></p>
            <p class="cozmoslabs-description"><strong><?php esc_html_e("Standard Tags:", 'profile-builder'); ?></strong></p>
            <ol style="margin-top: 10px;">
                <li class="cozmoslabs-description"><strong>{{homeurl}}</strong> - <?php esc_html_e("generates a url of the current website homepage.", 'profile-builder'); ?></li>
                <li class="cozmoslabs-description"><strong>{{siteurl}}</strong> - <?php echo wp_kses_post( __("in WordPress the <a target='_blank' href='https://codex.wordpress.org/Function_Reference/site_url'>site url</a> can be different then the home url", 'profile-builder') ); ?></li>
                <li class="cozmoslabs-description"><strong>{{user_id}}</strong> - <?php esc_html_e("the ID of the user", 'profile-builder'); ?></li>
                <li class="cozmoslabs-description"><strong>{{user_nicename}}</strong> - <?php esc_html_e("the URL sanitized version of the username, the user nicename can be safely used in URLs since it can't contain special characters or spaces.", 'profile-builder'); ?></li>
                <li class="cozmoslabs-description"><strong>{{http_referer}}</strong> - <?php esc_html_e("the URL of the previously visited page", 'profile-builder'); ?></li>
                <li class="cozmoslabs-description"><strong>{{redirect_to}}</strong> - <?php esc_html_e("the default URL set by WordPress after login", 'profile-builder'); ?></li>
            </ol>
            
            <?php if ( function_exists( 'pms_get_subscription_plans' ) ) : ?>
            <p class="cozmoslabs-description" style="margin-top: 15px;"><strong><?php esc_html_e("PMS Subscription Tags:", 'profile-builder'); ?></strong></p>
            <ol style="margin-top: 10px;">
                <li class="cozmoslabs-description"><strong>{{subscription_plan_name}}</strong> - <?php esc_html_e("the name of the user's subscription plan", 'profile-builder'); ?></li>
                <li class="cozmoslabs-description"><strong>{{subscription_plan_id}}</strong> - <?php esc_html_e("the ID of the user's subscription plan", 'profile-builder'); ?></li>
                <li class="cozmoslabs-description"><strong>{{subscription_status}}</strong> - <?php esc_html_e("the current status of the subscription (active, expired, cancelled, etc.)", 'profile-builder'); ?></li>
                <li class="cozmoslabs-description"><strong>{{subscription_price}}</strong> - <?php esc_html_e("the price of the subscription plan", 'profile-builder'); ?></li>
            </ol>
            <?php endif; ?>
        </div>
    </div>

<?php
}
add_action('wck_metabox_content_wppb_custom_redirects_info', 'wppb_add_content_before_custom_redirects_info');


/* the function that adds the jQuery script after form actions */
function wppb_add_script_after_form_actions() {
	echo '<script type="text/javascript">wppb_custom_redirects_user_radio();</script>';
}
add_action( 'wck_ajax_add_form_wppb_cr_user', 'wppb_add_script_after_form_actions' );
add_action( 'wck_after_adding_form_wppb_cr_user', 'wppb_add_script_after_form_actions' );
add_action( 'wck_refresh_list_wppb_cr_user', 'wppb_add_script_after_form_actions' );
add_action( 'wck_refresh_entry_wppb_cr_user', 'wppb_add_script_after_form_actions' );


/* the function needed to check Individual User Redirects duplicate entries */
function wppb_cr_user_check_duplicate_entries( $values ) {
	if( empty( $values['id'] ) || $values['id'] == 0 ) {
		$values['id'] = 1;
	}

	return $values;
}
add_action( 'wck_update_meta_filter_values_wppb_cr_user', 'wppb_cr_user_check_duplicate_entries' );

/* the function needed to check User Role based Redirects duplicate entries */
function wppb_cr_role_check_duplicate_entries( $values ) {
	if( empty( $values['id'] ) || $values['id'] == 0 ) {
		$values['id'] = 1;
	}

	return $values;
}
add_action( 'wck_update_meta_filter_values_wppb_cr_role', 'wppb_cr_role_check_duplicate_entries' );

/* the function needed to check Global Redirects duplicate entries */
function wppb_cr_global_check_duplicate_entries( $values ) {
	if( empty( $values['id'] ) || $values['id'] == 0 ) {
		$values['id'] = 1;
	}

	return $values;
}
add_action( 'wck_update_meta_filter_values_wppb_cr_global', 'wppb_cr_global_check_duplicate_entries' );

/* the function needed to check Default WordPress Forms and Pages Redirect duplicate entries */
function wppb_cr_default_wp_pages_check_duplicate_entries( $values ) {
	if( empty( $values['id'] ) || $values['id'] == 0 ) {
		$values['id'] = 1;
	}

	return $values;
}
add_action( 'wck_update_meta_filter_values_wppb_cr_default_wp_pages', 'wppb_cr_default_wp_pages_check_duplicate_entries' );

/* the function needed to check Subscription Plan based Redirects duplicate entries */
function wppb_cr_subscription_plan_check_duplicate_entries( $values ) {
	if( empty( $values['id'] ) || $values['id'] == 0 ) {
		$values['id'] = 1;
	}

	return $values;
}
add_action( 'wck_update_meta_filter_values_wppb_cr_subscription_plan', 'wppb_cr_subscription_plan_check_duplicate_entries' );


/**
 * Function that checks several things when adding/editing the Custom Redirects fields
 *
 * @param	string		$message			- the message to be displayed
 * @param	array		$fields				- the added fields
 * @param	array		$required_fields	- the required fields
 * @param	string		$meta_name			- the meta-name of the option
 * @param	string		$pv					- the values entered for each option
 * @param	integer		$post_id			- the post id
 *
 * @return	boolean
 */
function wppb_cr_check_field_on_edit_add( $message, $fields, $required_fields, $meta_name, $pv, $post_id ) {
	if( $meta_name == 'wppb_cr_user' || $meta_name == 'wppb_cr_role' || $meta_name == 'wppb_cr_global' || $meta_name == 'wppb_cr_default_wp_pages' || $meta_name == 'wppb_cr_subscription_plan' ) {
		$$meta_name = get_option( $meta_name, 'not_found' );

		if ( $$meta_name != 'not_found' ) {
			foreach( $$meta_name as $opt ) {
				if( empty( $pv['id'] ) || $pv['id'] == 0 ) {
					if( ( ! empty( $pv['user'] ) && ! empty( $pv['type'] ) && ! empty( $pv['idoruser'] ) && $pv['user'] == $opt['user'] && $pv['type'] == $opt['type'] && $pv['idoruser'] == $opt['idoruser'] )
						|| ( ! empty( $pv['user_role'] ) && ! empty( $pv['type'] ) && $pv['user_role'] == $opt['user_role'] && $pv['type'] == $opt['type'] )
						|| ( ! empty( $pv['subscription_plan'] ) && ! empty( $pv['type'] ) && $pv['subscription_plan'] == $opt['subscription_plan'] && $pv['type'] == $opt['type'] )
						|| ( ! empty( $pv['type'] ) && $meta_name == 'wppb_cr_global' && $pv['type'] == $opt['type'] )
						|| ( ! empty( $pv['type'] ) && $meta_name == 'wppb_cr_default_wp_pages' && $pv['type'] == $opt['type'] ) ) {

						$message = "\n" . __( "You can't add duplicate redirects!", 'profile-builder' ) . "\n";
					} elseif( ! empty( $pv['user'] ) && ! empty( $pv['type'] ) && ! empty( $pv['idoruser'] ) ) {
						if( $pv['idoruser'] == 'user' ) {
							$wppb_cr_userdata = get_user_by( 'login', $pv['user'] );

							if( isset( $wppb_cr_userdata ) && $wppb_cr_userdata->ID == $opt['user'] && $pv['type'] == $opt['type'] && $opt['idoruser'] == 'userid' ) {
								$message = "\n" . __( "You can't add duplicate redirects!", 'profile-builder' ) . "\n";
							}
						} elseif( $pv['idoruser'] == 'userid' ) {
							$wppb_cr_userdata = get_user_by( 'id', $pv['user'] );

							if( isset( $wppb_cr_userdata ) && $wppb_cr_userdata->user_login == $opt['user'] && $pv['type'] == $opt['type'] && $opt['idoruser'] == 'user' ) {
								$message = "\n" . __( "You can't add duplicate redirects!", 'profile-builder' ) . "\n";
							}
						}
					}
				}
			}
		}
	}

	return $message;
}
add_filter( 'wck_extra_message', 'wppb_cr_check_field_on_edit_add', 10, 6 );